<?php

namespace UtillzCore\Inc\Src\Form\Modules\Icon;

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Form\Component as Form;
use \UtillzCore\Inc\Src\Form\Modules\Module;
use \UtillzCore\Inc\Src\Form\Modules\Icon\Sets;

class Icon extends Module {

    public function controller() {

        $form = new Form( Form::Storage_Meta );

        $sets_options = [
            'font-awesome' => esc_html__('Font Awesome', 'utillz-core'),
            'material-icons' => esc_html__('Material Icons', 'utillz-core'),
        ];

        foreach( utillz_core()->icon->custom_sets as $set_key => $set ) {
            $sets_options[ $set_key ] = $set['name'];
        }

        $data_set = $data_icon = '';
        $icon_data = Ucore()->json_decode( $this->props->value );
        if( ! empty( $icon_data ) ) {
            $data_set = $icon_data[0]->set;
            $data_icon = $icon_data[0]->icon;
        }

        if( is_array( $this->props->value ) ) {
            $this->props->value = json_encode( $this->props->value );
        }

        return array_merge( (array) $this->props, [
            'form' => $form,
            'set' => $data_set,
            'icon' => $data_icon,
            'sets_options' => $sets_options,
            'strings' => (object) [
                'select' => esc_html__('Select icon', 'utillz-core'),
                'search' => esc_html__('Search icon ...', 'utillz-core'),
                'remove' => esc_html__('Remove icon', 'utillz-core'),
            ]
        ]);

    }

    public function after_save( $post_id, $value ) {

        update_post_meta( $post_id, $this->props->id . '__set', sanitize_text_field( $_POST[ sprintf('%s__set', $this->props->id) ] ) );
        update_post_meta( $post_id, $this->props->id . '__icon', sanitize_text_field( $_POST[ sprintf('%s__icon', $this->props->id) ] ) );
        return $value;

    }

    public static function get_sets() {

        $sets = [
            'font-awesome' => esc_html__('Font Awesome', 'utillz-core'),
            'material-icons' => esc_html__('Material Icons', 'utillz-core'),
        ];

        foreach( utillz_core()->icon->custom_sets as $key => $set ) {
            $sets[ $key ] = $set['name'];
        }

        return $sets;

    }

    public static function get_icons( $set_id, $selected = '' ) {

        $icons = [];
        $request = Request::instance();

        if( empty( $set_id ) ) {
            $set_id = 'font-awesome';
        }

        switch( $set_id ) {
            case 'font-awesome':

                $set = Sets\Font_Awesome::instance();
                foreach( $set->get() as $icon ) {
                    $active = ( $icon == $selected ) ? ' class="ulz--active"' : '';
                    $name = self::clean_name( $icon );
                    $icons[] = "<li{$active} data-icon='{$icon}'><i class='{$icon}'></i><span>{$name}</span></li>";
                }
                return $icons;

            case 'material-icons':

                $set = Sets\Material_Icons::instance();
                foreach( $set->get() as $icon ) {
                    $active = ( $icon == $selected ) ? ' class="ulz--active"' : '';
                    $name = self::clean_name( $icon );
                    $icons[] = "<li{$active} data-icon='{$icon}'><i class='material-icons'>{$icon}</i><span>{$name}</span></li>";
                }
                return $icons;

            default:

                $custom_sets = utillz_core()->icon->custom_sets;
                if( isset( $custom_sets[ $request->get('set') ] ) ) {
                    foreach( $custom_sets[ $request->get('set') ]['icons'] as $icon ) {
                        $active = ( $icon == $selected ) ? ' class="ulz--active"' : '';
                        $prefix = $custom_sets[ $request->get('set') ]['prefix'];
                        $name = self::clean_name( $icon );
                        $icons[] = "<li{$active} data-icon='{$icon}'><i class='{$prefix} {$prefix}{$icon}'></i><span>{$name}</span></li>";
                    }
                }
                return $icons;

        }

    }

    public static $icon_prefixes = [
        'fas fa-',
        'far fa-',
        'fab fa-',
    ];

    public static function clean_name( $name ) {
        foreach( self::$icon_prefixes as $prefix ) {
            $name = str_replace( $prefix, '', $name );
        }
        if( strlen( $name ) > 15 ) {
            $name = substr( $name, 0, 20 ) . '..';
        }
        $name = str_replace( '_', '-', $name );
        return $name;
    }

}
